/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImageBlinkItem;
import cds.aladin.PlanImageCube;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanRGBInterface;
import cds.aladin.ResourceNode;
import java.awt.image.ColorModel;
import java.util.Vector;

public final class PlanImageCubeRGB
extends PlanImageCube
implements PlanRGBInterface {
    private int[] pixelsZoomRGB = null;

    protected PlanImageCubeRGB(Aladin aladin, String file, MyInputStream in, String label, String from, Obj o, ResourceNode imgNode, boolean skip, boolean doClose, Plan forPourcent) {
        super(aladin, file, in, label, from, o, imgNode, skip, doClose, forPourcent);
        this.type = 20;
        this.initDelay = 400;
    }

    @Override
    protected void copy(Plan p1) {
        super.copy(p1);
        if (!(p1 instanceof PlanImageRGB)) {
            return;
        }
        PlanImageRGB p = (PlanImageRGB)p1;
        p.pixelsRGB = this.getPixelsRGB();
    }

    protected int[] getFrameRGB(int n) {
        return ((PlanImageBlinkItem)this.vFrames.elementAt((int)n)).pixelsRGB;
    }

    @Override
    protected boolean cacheImageFits(MyInputStream dis) throws Exception {
        int n;
        Aladin.trace(2, "Loading FITS " + Tp[this.type]);
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, dis);
        }
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        if (this.bitpix != 32 && this.bitpix != 24) {
            this.error = "BITPIX must be 24 or 32 for RGB or ARGB FITS cube !";
            return false;
        }
        this.setPixMode(this.bitpix == 32 ? 0 : 1);
        int naxis = this.headerFits.getIntFromHeader("NAXIS");
        if (naxis <= 1 && this.headerFits.getStringFromHeader("EXTEND") != null) {
            this.error = "_HEAD_XFITS_";
            if (naxis == 1) {
                try {
                    this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                    dis.skip(this.naxis1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        this.naxis1 = this.width = this.headerFits.getIntFromHeader("NAXIS1");
        this.naxis2 = this.height = this.headerFits.getIntFromHeader("NAXIS2");
        this.depth = this.headerFits.getIntFromHeader("NAXIS3");
        this.npix = n = this.bitpix / 8;
        long taille = (long)this.width * (long)this.height * (long)this.depth * (long)n;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " NAXIS3=" + this.depth + " BITPIX=" + this.bitpix + " => size=" + taille);
        this.loadFitsHeaderParam(this.headerFits);
        if (this.flagSkip) {
            dis.skip(taille);
        } else {
            double requiredMo = (double)taille / 1048576.0;
            boolean loadInRam = this.aladin.getMem() - requiredMo > 10.0;
            Aladin.trace(4, "PlanImageCubeColor.loadImageFits() required " + requiredMo + "MB " + (loadInRam ? "" : "=> not enough space in RAM"));
            if (!loadInRam) {
                this.error = "Not enough RAM space";
                return false;
            }
            byte[] buf = new byte[this.width * this.height * n];
            for (int i = 0; i < this.depth; ++i) {
                dis.readFully(buf);
                int[] pixelsRGB = this.extractImageRGB(buf, this.width, this.height, n, i);
                this.addFrame(this.label, pixelsRGB);
                this.setPourcent(99.0 * (double)i / (double)this.depth);
            }
            this.noOriginalPixels();
        }
        if (naxis > 3) {
            try {
                long offset = n * this.width * this.height;
                for (int i = 3; i < naxis; ++i) {
                    offset *= (long)this.headerFits.getIntFromHeader("NAXIS" + (i + 1));
                }
                dis.skip(offset -= (long)(n * this.width * this.height));
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.flagSkip) {
            return true;
        }
        this.cm = ColorModel.getRGBdefault();
        this.setPourcent(-1.0);
        return true;
    }

    private int[] extractImageRGB(byte[] buf, int width, int height, int npix, int frame) {
        int[] pixelsRGB = new int[width * height];
        int j = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pix = 0;
                for (int i = 0; i < npix; ++i) {
                    int c = 0xFF & buf[j++];
                    pix = pix << 8 | c;
                }
                pixelsRGB[(height - y - 1) * width + x] = 0xFF000000 | pix;
            }
        }
        return pixelsRGB;
    }

    protected synchronized void addFrame(String label, int[] pixelsRGB) {
        if (this.vFrames == null) {
            this.vFrames = new Vector();
        }
        this.vFrames.addElement(new PlanImageBlinkItem(label, pixelsRGB));
    }

    @Override
    public int[] getPixelsRGB() {
        double frame = this.aladin.view.getCurrentView().getCurrentFrameLevel();
        return this.getFrameRGB((int)frame);
    }

    @Override
    public int getPixel8(int x, int y) {
        int[] pixelsRGB = this.getPixelsRGB();
        return pixelsRGB[y * this.width + x];
    }

    public void getPixels(int[] newpixels, int x, int y, int w, int h, int frame) {
        int k = 0;
        int[] pixelsRGB = this.getFrameRGB(frame);
        int ah = 0;
        int aw = 0;
        if (x + w > this.width) {
            aw = x + w - this.width;
            w -= aw;
        }
        if (y + h > this.height) {
            ah = y + h - this.height;
            h -= ah;
        }
        int n = y + h;
        for (int i = y; i < n; ++i) {
            System.arraycopy(pixelsRGB, i * this.width + x, newpixels, k, w);
            k += w + aw;
        }
    }

    @Override
    public void getPixels(int[] newpixels, int x, int y, int w, int h) {
        double frame = this.aladin.view.getCurrentView().getCurrentFrameLevel();
        this.getPixels(newpixels, x, y, w, h, (int)frame);
    }

    @Override
    public int[] getPixelsZoomRGB() {
        return this.pixelsZoomRGB;
    }

    @Override
    public void calculPixelsZoomRGB() {
        int[] pixelsRGB = this.getPixelsRGB();
        this.pixelsZoomRGB = PlanImageRGB.calculPixelsZoomRGB1(this.aladin, this.pixelsZoomRGB, pixelsRGB, this.width, this.height);
    }
}

